--[[
http://legion.itzg.pl/mzgb/pmwiki/pmwiki.php?n=JaggedAlliance2UBV1.Jav113lua
Remember! Not to use function EndQuest(QuestID, x, y) and StartQuest(QuestID, x, y) in the file "Quests.lua".
]]


nQuests = 
{
	-- Quests ID							-- BinaryData\QUESTS.EDT Record
	QUEST_DELIVER_LETTER = 0,				-- Start quest 0, End quest 1
	QUEST_FOOD_ROUTE = 1,					-- Start quest 2, End quest 3
	QUEST_KILL_TERRORISTS = 2,				-- Start quest 4, End quest 5
	QUEST_KINGPIN_IDOL = 3,					-- Start quest 6, End quest 7
	QUEST_KINGPIN_MONEY = 4,				-- Start quest 8, End quest 9
	QUEST_RUNAWAY_JOEY = 5,					-- Start quest 10, End quest 11
	QUEST_RESCUE_MARIA = 6,					-- Start quest 12, End quest 13
	QUEST_CHITZENA_IDOL = 7,				-- Start quest 14, End quest 15
	QUEST_HELD_IN_ALMA = 8,					-- Start quest 16, End quest 17
	QUEST_INTERROGATION = 9,				-- Start quest 18, End quest 19
	QUEST_ARMY_FARM = 10,					-- Start quest 20, End quest 21
	QUEST_FIND_SCIENTIST = 11,				-- Start quest 22, End quest 23
	QUEST_DELIVER_VIDEO_CAMERA = 12,		-- Start quest 24, End quest 25
	QUEST_BLOODCATS = 13,					-- Start quest 26, End quest 27
	QUEST_FIND_HERMIT = 14,					-- Start quest 28, End quest 29
	QUEST_CREATURES = 15,					-- Start quest 30, End quest 31
	QUEST_CHOPPER_PILOT = 16,				-- Start quest 32, End quest 33
	QUEST_ESCORT_SKYRIDER = 17,				-- Start quest 34, End quest 35
	QUEST_FREE_DYNAMO = 18,					-- Start quest 36, End quest 37
	QUEST_ESCORT_TOURISTS = 19,				-- Start quest 38, End quest 39
	QUEST_FREE_CHILDREN = 20,				-- Start quest 40, End quest 41
	QUEST_LEATHER_SHOP_DREAM = 21,			-- Start quest 42, End quest 43
	QUEST_ESCORT_SHANK = 22,				-- Start quest 44, End quest 45
	QUEST_23 = 23,							-- Start quest 46, End quest 47
	QUEST_24 = 24,							-- Start quest 48, End quest 49
	QUEST_KILL_DEIDRANNA = 25,				-- Start quest 50, End quest 51
	-- Legion 2
	QUEST_WARTOWNIA = 26,					-- Start quest 52, End quest 53
	QUEST_SIERZANT = 27,					-- Start quest 54, End quest 55
	QUEST_KARLOS = 28,						-- Start quest 56, End quest 57
	
	-- max Quests 254
}

qStatus = {
            QUESTNOTSTARTED = 0,
            QUESTINPROGRESS = 1,
            QUESTDONE = 2,
          }
		  
Profiles = 
{	
	DYNAMO = 66,
	CARMEN = 78,
	MADAME = 107,
}

nHistory = {
	HISTORY_QUEST_STARTED = 15,
	HISTORY_QUEST_FINISHED = 16,
	}
	
nFacts = {

	FACT_ESTONI_REFUELLING_POSSIBLE = 277,

}

GroupStatus = 
{
	CIV_GROUP_NEUTRAL = 0,
	CIV_GROUP_WILL_EVENTUALLY_BECOME_HOSTILE = 1,
	CIV_GROUP_WILL_BECOME_HOSTILE = 2,
	CIV_GROUP_HOSTILE = 3,
}

SectorY = 
{
	MAP_ROW_A = 1,
	MAP_ROW_B = 2,
	MAP_ROW_C = 3,
	MAP_ROW_D = 4,
	MAP_ROW_E = 5,
	MAP_ROW_F = 6,
	MAP_ROW_G = 7,
	MAP_ROW_H = 8,
	MAP_ROW_I = 9,
	MAP_ROW_J = 10,
	MAP_ROW_K = 11,
	MAP_ROW_L = 12,
	MAP_ROW_M = 13,
	MAP_ROW_N = 14,
	MAP_ROW_O = 15,
	MAP_ROW_P = 16,
}
	
local NO_PROFILE = 200

local Min = 0

-- Funkcja Legion2_CheckFact jest używana tylko w modyfikacji Legion 2.
function Legion2_CheckFact (usFact, ubProfileID)

	if (usFact == 369) then
		-- Sprawdź fakt czy Billy nie żyje.
		gubFact (369, ( CheckMercIsDead( 133 ) ) )

	elseif (usFact == 370) then
		-- Wartownia

	elseif (usFact == 372) then
		-- Atak na I8
		
		if ( CheckGlobalBool(33) == false ) then
			if ( newDIFFICULTY_LEVEL == DIF_LEVEL_EASY) then
				i = math.random(1, 2)
				Legion2_AddEnemyToSector (8,SectorY.MAP_ROW_I,8 + difficultyLevel + i,0,0)
			elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_MEDIUM )then
				i = math.random(1, 2)
				Legion2_AddEnemyToSector (8,SectorY.MAP_ROW_I,12 + difficultyLevel + i,0,0)
			elseif ( newDIFFICULTY_LEVEL == DIF_LEVEL_HARD )then
				i = math.random(1, 2)
				Legion2_AddEnemyToSector (8,SectorY.MAP_ROW_I,15 + difficultyLevel + i,0,0)
			elseif( newDIFFICULTY_LEVEL == DIF_LEVEL_INSANE )then
				i = math.random(1, 2)
				Legion2_AddEnemyToSector (8,SectorY.MAP_ROW_I,20 + difficultyLevel + i,0,0)	
			end
		end
		
	elseif (usFact == 373) then
		-- Pakos w H12. Zadanie od Fatimy
		if (NPCInRoom( 114, 24 ) and CheckNPCSectorBool( 114,12,7,0 ) == true ) then
			gubFact (373, true )
		end
		
	elseif (usFact == 374) then
		-- Sklep aktywny
		if ( Legion2_BobbyRSiteCanBeAccessed == true ) then
			gubFact (374, true )
		else
			gubFact (374, false )
		end

	elseif (usFact == 375) then
		-- Anuluj ograniczenie gry
		if ( CheckGlobalBool(22) == true ) then
			gubFact (375, true )
		else
			gubFact (375, false )
		end

	elseif (usFact == 376) then
		-- Sprawdź fakt czy Maria wolna.
		gubFact (376, ( CheckNPCIsEPC( 88 ) ) )

	elseif (usFact == 377) then
		-- Sprawdź fakt czy Karlos nie żyje.
		gubFact (377, ( CheckMercIsDead (86) ) )
		
	elseif (usFact == 378) then
		-- Sprawdź fakt czy Chris nie żyje.
		gubFact (378, ( CheckMercIsDead (83) ) )
			
	elseif (usFact == 379) then
		-- dodaj pieniądze na konto
		if ( CheckGlobalBool(23) == true ) then
			gubFact (379, true )
		else
			gubFact (379, false )
		end
		
	elseif (usFact == 380) then
		-- Sprawdź czy fakt jest prawdą.
		-- Fakt jest wymagany przy wyborze gry bez ograniczenia czasu.
		if ( NPCInRoom( 88, 3 ) and CheckNPCSectorBool( 88,4,16,0 ) == true ) then
			gubFact (380, true )
		end
		
	elseif (usFact == 381) then
		-- Sprawdź fakt czy sektor F9 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 9,SectorY.MAP_ROW_F ) ) == true ) then
			gubFact ( 381, true )
		else
			gubFact ( 381, false )
		end
		
	elseif (usFact == 382) then
		-- Sprawdź fakt czy ubProfileID(najemnik gracza) widzi Bobiego.		
		if (CheckNPCWithin( ubProfileID, 73, 100 ) ) then
			gubFact (382, true )
		else 
			gubFact (382, false )
		end	
		
	elseif (usFact == 383) then
		-- Sprawdź fakt czy Bobi nie żyje.
		gubFact (383, ( CheckMercIsDead (73) ) )
		
	elseif (usFact == 384) then
		-- Spike pieniądze
		gubFact (384, ( CheckMoney(93) >= CheckGlobalVal (106) ) )
					
	elseif (usFact == 385) then
		-- Ilość dnido końca 15
		gubFact (385, true )
		
	elseif (usFact == 386) then
		-- Ilość dnido końca 25
		gubFact (386, true )
		
	elseif (usFact == 387) then
		-- Ilość dnido końca 30
		gubFact (387, true )
		
	elseif (usFact == 388) then
		-- Ilość dnido końca 40
		gubFact (388, true )
		
	elseif (usFact == 391) then
		-- Sprawdź fakt czy sektor D7 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 7,SectorY.MAP_ROW_D ) ) == true ) then
			gubFact (391, false)
		else
			gubFact (391, true )
		end
		
	elseif (usFact == 392) then
		-- haker pieniądze
		gubFact (392, ( CheckMoney(90) >= CheckGlobalVal(107) ) )
					
	elseif (usFact == 393) then
		-- Sprawdź fakt czy Spike nie żyje.
		gubFact (393, ( CheckMercIsDead (93) ) )
			
	elseif (usFact == 394) then
		
		-- Sprawdź fakt czy haker jest w sektorze G12
		if ( CheckNPCSectorBool( 90,12,SectorY.MAP_ROW_G,0 ) == true ) then
			gubFact (394, true )
		end
		
	elseif (usFact == 395) then
		-- Sprawdź fakt czy sektor B3 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 3,SectorY.MAP_ROW_B ) ) == true ) then
			gubFact (395, true)
		else
			gubFact (395, false )
		end
			
	elseif (usFact == 396) then
		-- Sprawdź czy fakt jest prawdą.
		-- Powiązane z profilem "NPCData\60.npc" rekord 25.
		-- Fakt jest wymagany przy wyborze gry bez ograniczenia czasu.
		gubFact (396, true)
			
	elseif (usFact == 397) then
		-- Sprawdź fakt czy sektor N5 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 5,SectorY.MAP_ROW_N ) ) == true ) then
			gubFact (397, true)
		else
			gubFact (397, false )
		end
		
	elseif (usFact == 398) then
		
		-- Sprawdź fakt czy marynarz jest w sektorze N5
		if ( CheckNPCSectorBool( 116,5,SectorY.MAP_ROW_N,0 ) == true ) then
			gubFact (398, true )
		else 
			gubFact (398, false )
		end
		
	elseif (usFact == 399) then
		
		-- Maria w G12
		-- Nieużywane.
		if ( CheckNPCSectorBool( 88,12,7,0 ) == false ) then
			gubFact (399, false )
		else 
			gubFact (399, (NPCInRoom( 88, 38 ) ) )
		end
		
	elseif (usFact == 401) then
			-- Sprawdź czy grupa 48 jest wrogo nastawiona
			gubFact (401, ( CheckCivGroupHostile(48) >= GroupStatus.CIV_GROUP_WILL_BECOME_HOSTILE ) )
		
	elseif (usFact == 402) then
		
		-- Sprawdź fakt czy ubProfileID(najemnik gracza) widzi Tine(59).
		-- Jeżeli Tina znajduje się w sektorze A15 oraz w pomieszczeniu (16) zostanie wykonany fakt.
		if ( CheckNPCSectorBool( 59,15,1,0 ) == true and CheckNPCWithin( ubProfileID, 59, 10 ) == true and NPCInRoom( 59, 16 ) == true ) then
			gubFact (402, true )
		else 
			gubFact (402, false )
		end
		
	elseif (usFact == 406) then
		-- Sprawdź fakt czy ubProfileID(najemnik gracza) widzi Jacka(66) oraz Spika (93) i Jack(66) znajduje się w sektorze G12 oraz czy globalna (8) jest fałszem.	
		-- Jeżeli wszystko jest wykonane prawidłowo fakt (406) przybierze wartość "true - prawda"
		if ( CheckNPCSectorBool( 66,12,7,0 ) == true and CheckNPCWithin( ubProfileID, 66, 10 ) == true and CheckNPCWithin( ubProfileID, 93, 10 ) == true and CheckGlobalBool(8) == false ) then
			gubFact (406, true )
		end
	
	elseif (usFact == 409) then
		-- Sprawdź fakt czy ubProfileID(najemnik gracza) widzi Flint'a.		
		if (CheckNPCWithin( ubProfileID, 150, 10 ) ) then
			gubFact (409, true )
		else 
			gubFact (409, false )
		end
		
	elseif (usFact == 410) then
		-- Sprawdź fakt czy Flint jest w miejscu 7904.
		gubFact (410, CheckNPCAt( 150, 7904 ) )
		
	elseif (usFact == 412) then
		-- Sprawdź fakt czy Jax nie żyje.
		if ( CheckMercIsDead (121) == true ) then
			gubFact (412, true )
		end
		
	elseif (usFact == 413) then
		-- Sprawdź fakt czy Flint nie żyje.
		if ( CheckMercIsDead (150) == true ) then
			gubFact (413, true )
		end
		
	elseif (usFact == 419) then
		-- Sprawdź fakt czy sektor O15 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 15,SectorY.MAP_ROW_O ) ) == true ) then
			gubFact (419, true)
		else
			gubFact (419, false )
		end
		
	elseif (usFact == 420) then
		-- Sprawdź fakt czy sektor P15 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 15,SectorY.MAP_ROW_P ) ) == true ) then
			gubFact (420, false)
		else
			gubFact (420, true )
		end	
	
	elseif (usFact == 421) then
		-- Sprawdź fakt czy sektor J15 jest pod kontrolą wroga.	
		if ( Legion2_SectorEnemyControlled ( CALCULATE_STRATEGIC_INDEX( 15,SectorY.MAP_ROW_J ) ) == true ) then
			gubFact (421, true)
		else
			gubFact (421, false )
		end
		
	elseif (usFact == 423) then 
		-- Sprawdź fakt czy Rain Man nie żyje.
		gubFact (423, ( CheckMercIsDead (69) ) )
		if ( GetgubFact(423) == true ) then
			EnvEndRainStorm()
		end
	-- Sprawdź fakt czy Ash nie żyje.
	elseif (usFact == 424) then
	
		if ( CheckMercIsDead (156) == true ) then
			gubFact (424, true )
		end
		
	-- Dostawa prądu do B3
	elseif (usFact == 425) then
		if ( CheckGlobalBool(49) == true ) then
			gubFact (425, true )
		end
		
	-- uwolnić mieszkańców
	elseif (usFact == 426) then
		if ( CheckGlobalBool(50) == true ) then
			gubFact (426, true )
		end
		
	-- Oswalda w L1. Alternatywne zakończenie głównego zadania.
	elseif (usFact == 432) then
		if ( GetgubFact (433) == true ) then
			gubFact (432, true )
		end
		
	elseif (usFact == 433) then
		-- Sprawdź czy fakt jest prawdą. Maria w sektorze L1 w pokoju 33.
		if ( NPCInRoom( 88, 33 ) == true and CheckNPCSectorBool( 88,1,12,0 ) == true ) then
			gubFact (433, true )
		else
			gubFact (433, false )
		end
		
	elseif (usFact == 437) then
		-- Sprawdź czy fakt jest prawdą.
		-- Maria w B4, w pokoju Asha
		if ( NPCInRoom( 88, 12 ) == true and CheckNPCSectorBool( 88,4,2,0 ) == true and CheckNPCIsEPC( 88 ) == true and GetgubFact (485) == false ) then
			gubFact ( 437, true )
		else
			gubFact (437, false )
		end
		
	elseif (usFact == 438) then
		-- Sprawdź czy fakt jest prawdą.
		-- Maria w B4, w pokoju Asha
		if ( CheckNPCSectorBool( 88,4,2,0 ) == true and CheckNPCIsEPC( 88 ) == false ) then
			gubFact ( 438, true )
		end
		
	-- Sprawdź fakt czy Ash nie żyje i Maria sprzedana.
	elseif ( usFact == 439 ) then
	
		if ( CheckMercIsDead (156) == true and GetgubFact (438) == true ) then
			gubFact (439, true )
		end
		
	-- Sprawdź fakt czy EPC Maria.
	elseif ( usFact == 440 ) then
	
		if ( CheckMercIsDead (156) == true and GetgubFact (438) == true ) then
			gubFact (440, true )
		end
		
	-- Sprawdź fakt Pacos nie żyje.
	elseif ( usFact == 446 ) then
	
		if ( CheckMercIsDead (114) == true ) then
			gubFact (446, true )
		end
		
	-- Sprawdź fakt, Pacos w pokoju Asha
	elseif ( usFact == 447 ) then
	
		if ( NPCInRoom( 114, 12 ) == true and CheckNPCSectorBool( 114,4,2,0 ) == true and CheckNPCIsEPC( 114 ) == true ) then
			gubFact (447, true )
		else
			gubFact (447, false )
		end
		
	-- Sprawdź fakt, Pacos sprzedany 2
	elseif ( usFact == 449 ) then
	
		if ( GetgubFact (448) == true ) then
			gubFact ( 449, false )
		else
			gubFact ( 449, true )
		end
		
	-- Sprawdź fakt, Maria nie jest sprzedana
	elseif ( usFact == 450 ) then
	
		if ( GetgubFact (438) == true ) then
			gubFact ( 450, false )
		else
			gubFact ( 450, true )
		end
		
	-- Sprawdź fakt, terroryści
	elseif ( usFact == 451 ) then
		
		-- ustaw fakt
		
	-- Sprawdź fakt, Brak faktu
	elseif ( usFact == 452 ) then
		--  puste
	
	-- Sprawdź fakt, Zapłać za aresztowanych
	elseif ( usFact == 453 ) then
		if ( CheckGlobalVal (100) > 0 ) then -- or GetgubFact (454) == true ) then
			gubFact ( 453, true )
		
		elseif ( CheckGlobalVal (100) == 0 or CheckGlobalVal (100) < 0 ) then
			gubFact ( 453, false )
		end
		
	-- Sprawdź fakt, Zapłać za aresztowaną Marię
	elseif ( usFact == 454 ) then
		if ( ( NPCInRoom( 88, 18 ) == true or NPCInRoom( 88, 13 ) == true  ) and CheckNPCSectorBool( 88,3,12,0 ) == true ) then
			gubFact ( 454, true )
		else
			gubFact ( 454, false )
		end
		
	-- Sprawdź fakt, Oswald,Maria i Alfred, koniec misji
	elseif ( usFact == 455 ) then
			
	-- Sprawdź fakt, Wolna Angel
	elseif ( usFact == 456 ) then
		Min = GetWorldMinutesInDay()
		-- Sektor D7. Godzina 6:05 lub 22:00
		if ( Min < 365 or Min > 1320 ) then
			gubFact ( 456, true )
		else
			gubFact ( 456, false )
		end	
		
	-- Sprawdź fakt, Angel w drużynie
	elseif ( usFact == 457  ) then
		
		if ( CheckNPCIsRPC( 102 ) == true and Legion2_CheckMercID() == 102 ) then
			gubFact ( 457, true )
		else
			gubFact ( 457, false )
		end	
		
	-- Sprawdź fakt, Angel w drużynie
	elseif ( usFact == 458 ) then
		-- używany fakt

	-- Sprawdź fakt, Punkt graniczny Osarwi
	elseif ( usFact == 459 ) then
		-- używany fakt
		
	-- Sprawdź fakt, Punkt graniczny Osarwi
	elseif ( usFact == 460 ) then
		-- używany fakt
			
	-- Sprawdź fakt, Rozmowa z Prof115
	elseif ( usFact == 461 ) then
		-- używany fakt
		
	-- Sprawdź fakt czy prof 80 żyje lub nie
	elseif ( usFact == 462 ) then
	
		if ( CheckMercIsDead (80) == true ) then
			gubFact (462, true )
		end
		
	-- Sprawdź fakt, czy zadanie 34 zakończone
	elseif ( usFact == 463 ) then
	
		if ( CheckQuest(34) == qStatus.QUESTDONE ) then
			gubFact (463, true )
		end
		
	-- Sprawdź fakt
	elseif ( usFact == 469 ) then
	
		if ( ( CheckTalkerFemale() == true or CheckTalkerFemale() == false ) ) then
			gubFact (469, true )
		end
		
	-- Sprawdź fakt, Powiedź czy Karlos w C7
	elseif ( usFact == 470 ) then
	
		-- używane w 097.npc
		
	-- Alfred umarł
	elseif ( usFact == 479 ) then
		if ( CheckGlobalBool(427) == true or CheckGlobalBool(425) == true ) then
			gubFact ( 479, false )
		else
			gubFact ( 479, true )
		end
		
	-- 482
	elseif ( usFact == 482 ) then
		if ( CheckGlobalBool(436) == true ) then
			gubFact ( 482, true )
			gubFact ( 480, false )
			gubFact ( 481, false )
		end
		
	end
	
end

function InternalStartQuest( ubQuest, sSectorX, sSectorY, fUpdateHistory )

	if ( CheckQuest(ubQuest) == qStatus.QUESTNOTSTARTED ) then 
		SetQuest( ubQuest, qStatus.QUESTINPROGRESS ) 	
			if ( fUpdateHistory == true) then		
				if ( is_networked == 0 ) then
					   SetHistoryFact( nHistory.HISTORY_QUEST_STARTED, ubQuest, GetWorldTotalMin(), sSectorX, sSectorY )
				end	
			end		
	else
		SetQuest( ubQuest, qStatus.QUESTINPROGRESS )
	end

end
		
function InternalEndQuest( ubQuest, sSectorX, sSectorY, fUpdateHistory )

  if ( not ( CheckQuest(ubQuest) == qStatus.QUESTDONE ) and fUpdateHistory == true ) then
    
		if ( ubQuest == nQuests.QUEST_FOOD_ROUTE ) then
			-- food quest is handled differently (completing when spoken to father Walker)
		elseif ( ubQuest == nQuests.QUEST_DELIVER_LETTER ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 3, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_LEATHER_SHOP_DREAM ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 3, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_ESCORT_SKYRIDER ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_CHOPPER_PILOT ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_FREE_CHILDREN ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_RESCUE_MARIA ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_FIND_SCIENTIST ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_DELIVER_VIDEO_CAMERA ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_FIND_HERMIT ) then	
				GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_FREE_DYNAMO ) then		
			
				-- don't give Dynamo reward for himself
				if ( CheckMercIsDead ( Profiles.DYNAMO ) == false ) then
					GiveQuestRewardPoint( sSectorX, sSectorY, 4, Profiles.DYNAMO )
				end
				
		elseif ( ubQuest == nQuests.QUEST_KINGPIN_IDOL ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_CHITZENA_IDOL ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_HELD_IN_ALMA ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_RUNAWAY_JOEY ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_ESCORT_TOURISTS ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		elseif ( ubQuest == nQuests.QUEST_ARMY_FARM ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 6, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_KINGPIN_MONEY ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 6, NO_PROFILE )		
		elseif ( ubQuest == nQuests.QUEST_BLOODCATS ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 7, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_INTERROGATION ) then
				-- we get here only if wiped out enemies after interrogation
				GiveQuestRewardPoint( sSectorX, sSectorY, 8, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_CREATURES ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 8, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_KILL_TERRORISTS ) then
				
				-- only reduced experiences if we chosen Slay over Carmen
				if ( CheckMercIsDead ( Profiles.CARMEN ) == true ) then
					GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )
				else
					GiveQuestRewardPoint( sSectorX, sSectorY, 9, NO_PROFILE )
				end	
				
		elseif ( ubQuest == nQuests.QUEST_KILL_DEIDRANNA ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 25, NO_PROFILE )
		elseif ( ubQuest == nQuests.QUEST_ESCORT_SHANK ) then
				GiveQuestRewardPoint( sSectorX, sSectorY, 5, NO_PROFILE )	
		else
			GiveQuestRewardPoint( sSectorX, sSectorY, 4, NO_PROFILE )	
		end
		
		
  end 
  
  if ( CheckQuest(ubQuest) == qStatus.QUESTINPROGRESS ) then
	
		SetQuest( ubQuest, qStatus.QUESTDONE ) 
			
		if ( fUpdateHistory == true ) then
			ResetHistoryFact( ubQuest, sSectorX, sSectorY )
		end
  else
	    SetQuest( ubQuest, qStatus.QUESTDONE ) 
  end

	if ( ubQuest == nQuests.QUEST_RESCUE_MARIA ) then
	
		-- cheap hack to try to prevent Madame Layla from thinking that you are
		-- still in the brothel with Maria...
		SetNPCData1(Profiles.MADAME, 0)
		SetNPCData2(Profiles.MADAME, 0)
	end
	
	
end